/**
* \file: VrTtsAudioChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample audio channel implementation for voice recognition text to speech
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_VRTTSAUDIOCHANNEL_H
#define BDCL_VRTTSAUDIOCHANNEL_H

#include <bdcl/AditAudioSink.h>

namespace adit { namespace bdcl {

class VrTtsAudioChannel : public IAditAudioSinkCallbacks
{
public:
    VrTtsAudioChannel(CoreCallbackDealer* inCallbackDealer);
    virtual ~VrTtsAudioChannel();

private:
    AditAudioSink* mAudioSink;
    bool isVrInterrupted;

    void onPlaybackInit(unsigned int inSampleRate, unsigned int inChannelConfig, unsigned int inSampleFormat);

    /** @brief Callback initiated by Baidu core to stop audio playback.
     */
    void onPlaybackStop();

    /** @brief Callback initiated by Baidu core to interrupt audio playback. This callback is only relevant for voice
     *         recognition text-to-speech channel
     */
    void onPlaybackInterrupt();

    /** @brief Callback initiated by ADIT to inform MC application about an error.
     */
    void onError(bdclErrorCodes inErrorCode);
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_VRTTSAUDIOCHANNEL_H */
